"use client"

import { useState, useMemo } from "react"
import { MenuHeader } from "@/components/menu-header"
import { MenuSection } from "@/components/menu-section"
import { MenuFooter } from "@/components/menu-footer"
import { MenuNavigation } from "@/components/menu-navigation"
import { BackToTop } from "@/components/back-to-top"
import { RecommendedItems } from "@/components/recommended-items" // Declare the RecommendedItems component

export default function MenuPage() {
  const [searchQuery, setSearchQuery] = useState("")
  const [activeFilter, setActiveFilter] = useState<"all" | "food" | "drinks">("all")

  const recommendedItems = [
    {
      name: "Grilled Prawns in Hot Plate",
      price: "25,000",
      category: "Grills",
      reason: "Premium seafood delicacy with perfectly grilled prawns served in a sizzling hot plate",
    },
    {
      name: "Platter for Boss",
      price: "95,500",
      category: "D Plug Special",
      reason: "Our signature feast featuring jollof rice, stir rice, turkey, goat meat, beef, snail, and plantain",
    },
    {
      name: "Seafood Platter",
      price: "80,000",
      category: "D Plug Special",
      reason: "An exquisite selection of the finest seafood offerings, perfectly prepared",
    },
    {
      name: "Dom Perignon",
      price: "680,000",
      category: "Champagne",
      reason: "The ultimate luxury champagne experience for special celebrations",
    },
    {
      name: "Grilled Full Chicken",
      price: "35,000",
      category: "Grills",
      reason: "Whole chicken grilled to perfection with our signature seasoning",
    },
    {
      name: "D' Plug Special Mix",
      price: "40,000",
      category: "D Plug Special",
      reason: "A carefully curated mix of our most popular dishes",
    },
  ]

  const foodSections = [
    {
      title: "Starters",
      items: [
        { name: "Chicken Spring Rolls", price: "5,500" },
        { name: "Vegetable Spring Roll", price: "5,000" },
        { name: "Beef Samosa", price: "6,000" },
        { name: "Vegetable Samosa", price: "5,000" },
        { name: "D.Plus Combo", price: "20,000", recommended: true },
        { name: "Shrimp Popcorn", price: "8,000" },
        { name: "Chicken Popcorn", price: "5,000" },
        { name: "Kiss Dodo", price: "6,000" },
        { name: "Chicken Nuggets", price: "6,000" },
      ],
    },
    {
      title: "Proteins",
      items: [
        { name: "Beef", price: "6,500" },
        { name: "Turkey", price: "9,000" },
        { name: "Chicken", price: "8,500" },
        { name: "Asun", price: "6,500" },
        { name: "Gizzard", price: "5,500" },
        { name: "Fried Croaker Fish", price: "6,500" },
        { name: "Goat Meat", price: "7,000" },
        { name: "Pepper Snail", price: "15,000", recommended: true },
        { name: "Chicken Drumstick with Chips", price: "12,500" },
      ],
    },
    {
      title: "D Plug Wings",
      items: [
        { name: "Buffalo Wings", price: "7,500" },
        { name: "BBQ Wings", price: "8,500", recommended: true },
        { name: "Pepper Chicken Wings", price: "6,000" },
        { name: "Deep Fried Chicken Wings", price: "7,000" },
      ],
    },
    {
      title: "Grills",
      items: [
        { name: "Big Croaker Fish", price: "15,500" },
        { name: "BBQ Croaker Fish", price: "13,500" },
        { name: "BBQ Catfish", price: "13,500" },
        { name: "Special BBQ Fish", price: "18,500" },
        { name: "Grilled Prawns in Hot Plate", price: "25,000", recommended: true },
        { name: "Special Prawns with Sweet Potato or Chips", price: "15,000" },
        { name: "T Bone Steak with Sweet Potato or Mashed Potato", price: "30,000" },
        { name: "Rib Eye Steak with Jollof or Mashed Potato", price: "27,000" },
        { name: "Lamb Chops Steak with Sweet Potato", price: "25,000" },
        { name: "Lamb Cut Let Steak with Mashed Potato", price: "30,000" },
        { name: "Grill Turkey", price: "12,000" },
        { name: "Grilled Full Chicken", price: "35,000", recommended: true },
        { name: "Half Grilled Chicken", price: "18,000" },
        { name: "Crab Seafood", price: "30,000" },
      ],
    },
    {
      title: "Pizza",
      items: [
        { name: "Margarita Pizza", price: "9,500" },
        { name: "Chicken Suya Pizza", price: "13,000", recommended: true },
        { name: "Vegetarian Pizza", price: "11,000" },
        { name: "Seafood Pizza", price: "14,000" },
        { name: "D'Plug Special Pizza", price: "12,000" },
        { name: "Pepperoni Pizza", price: "12,000" },
      ],
    },
    {
      title: "Burger",
      items: [
        { name: "Crispy Chicken Burger", price: "9,000" },
        { name: "Classic Beef Burger", price: "9,000" },
        { name: "Double Beef Burger", price: "14,000" },
      ],
    },
    {
      title: "Rice & Sides",
      items: [
        { name: "D'Plug Special Rice", price: "12,000", recommended: true },
        { name: "Jollof Rice", price: "6,500" },
        { name: "Chicken Curry with Rice", price: "12,000" },
        { name: "Shrimp Fried Rice", price: "7,000" },
        { name: "Chicken Stir Fried Rice", price: "7,500" },
        { name: "Beef Stir Fried Rice", price: "7,500" },
        { name: "Asun Jollof", price: "13,000" },
        { name: "Special Jollof", price: "10,000" },
        { name: "D'Plug Chinese Rice", price: "7,000" },
        { name: "Fried/Boiled Plantain", price: "5,500" },
        { name: "French Fries (Chips)", price: "4,500" },
        { name: "Chinese Spaghetti", price: "7,500" },
        { name: "Chinese Rice & Chicken Sauce", price: "7,000" },
        { name: "Native Rice", price: "7,500" },
        { name: "White Rice & Sauce", price: "7,500" },
        { name: "Fried Yam & Sauce", price: "8,500" },
        { name: "Fried Plantain & Sauce", price: "7,500" },
        { name: "Boiled Yam & Egg Sauce", price: "8,500" },
        { name: "Golden Yam & Egg Sauce", price: "9,500" },
      ],
    },
    {
      title: "Salad",
      items: [
        { name: "Coleslaw Salad", price: "5,500" },
        { name: "Tuna Salad", price: "8,000" },
        { name: "Vegetable Salad", price: "7,000" },
        { name: "Chicken Salad", price: "8,000" },
      ],
    },
    {
      title: "Pasta",
      items: [
        { name: "Spaghetti Bolognese", price: "8,500" },
        { name: "Alfredo Pasta", price: "8,500" },
        { name: "Seafood Pasta", price: "15,000", recommended: true },
        { name: "Stir Fried Spaghetti", price: "8,500" },
        { name: "Native Spaghetti", price: "7,500" },
      ],
    },
    {
      title: "D Plug Special",
      items: [
        { name: "Seafood Platter", price: "80,000", recommended: true },
        { name: "D' Plug Special Mix", price: "40,000", recommended: true },
        { name: "Pineapple Rice & Turkey or Chicken", price: "21,000" },
        { name: "Crab with Mashed Potato or Jollof", price: "30,000" },
        { name: "Chicken Platter", price: "36,000" },
        { name: "Turkey Platter", price: "38,000" },
        { name: "Goat Meat Platter", price: "35,500" },
        { name: "Platter for 2 Person", price: "27,500" },
        { name: "Platter for 3 Persons", price: "39,500" },
        { name: "Seafood Coconut Rice", price: "20,000" },
        {
          name: "Platter for Boss",
          price: "95,500",
          recommended: true,
          description:
            "(It Includes Jollof Rice, Stir Rice, White Rice, Turkey, Goat Meat, Beef, Snail, Plantain, Salad)",
        },
      ],
    },
    {
      title: "Noodles",
      items: [
        { name: "Noodles & Chicken", price: "10,000" },
        { name: "Noodles & Turkey", price: "10,500" },
        { name: "Chicken Stir Fried Noodles", price: "9,000" },
        { name: "Singapore Noodles", price: "10,000" },
        { name: "Native Noodles", price: "8,500" },
      ],
    },
    {
      title: "Snacks",
      items: [
        { name: "Shawarma", price: "5,000" },
        { name: "Tuna Sandwich", price: "8,500" },
        { name: "Baguette Sandwich", price: "7,500" },
        { name: "Club Sandwich", price: "7,000" },
      ],
    },
  ]

  const drinkSections = [
    {
      title: "Bitter and Sweet",
      items: [
        { name: "Campari", price: "32,000" },
        { name: "Campari (Small)", price: "17,000" },
        { name: "Jagermeister", price: "35,000" },
      ],
    },
    {
      title: "Cognac Brands",
      items: [
        { name: "Martell XO", price: "430,000", recommended: true },
        { name: "Martell VSOP", price: "140,000" },
        { name: "Martell VS", price: "90,000" },
        { name: "Henessy VSOP", price: "150,000" },
        { name: "Henessy VS", price: "80,000" },
        { name: "Henessy XO", price: "450,000" },
      ],
    },
    {
      title: "Smokes",
      items: [
        { name: "Shisha", price: "10,000" },
        { name: "Extra Shisha", price: "3,000" },
        { name: "Benson Switch", price: "3,000" },
        { name: "Shisha Vape", price: "20,000" },
      ],
    },
    {
      title: "Champagne",
      items: [
        { name: "Andre Rose", price: "40,000" },
        { name: "Martini Rose", price: "40,000" },
        { name: "Balaire Roase", price: "110,000" },
        { name: "Moet Brut", price: "150,000" },
        { name: "Remy Martin V.S.O.P", price: "120,000" },
        { name: "Verve", price: "220,000" },
        { name: "Dom Perignon", price: "680,000", recommended: true },
        { name: "Verve Clicquot (Small)", price: "120,000" },
        { name: "Verve Clicquot (Big)", price: "300,000" },
      ],
    },
    {
      title: "Wine",
      items: [
        { name: "Four Cousins", price: "20,000" },
        { name: "Calto Rossi Sweet Wine", price: "20,000" },
        { name: "Carto Rossi Sour Wine", price: "20,000" },
        { name: "Chandon", price: "20,000" },
        { name: "Agor Wine", price: "20,000" },
        { name: "Sweet Kiss Red", price: "25,000" },
        { name: "B & G Red Wine", price: "25,000" },
        { name: "Drevni Monch Pastoral Sweet Redwine", price: "25,000" },
        { name: "Baron Devais", price: "20,000" },
        { name: "Baron Romero", price: "20,000" },
        { name: "Declan Sweet Redwine", price: "25,000" },
      ],
    },
    {
      title: "Whiskey",
      items: [
        { name: "Chivas 12yrs", price: "60,000" },
        { name: "Chivas 15yrs", price: "110,000" },
        { name: "Chivas 18yrs", price: "150,000" },
        { name: "Casamigos", price: "220,000" },
        { name: "Observatory", price: "50,000" },
        { name: "Grant Wood", price: "30,000" },
        { name: "Signgleton 12yrs", price: "60,000" },
        { name: "The Balvanie 14yrs", price: "250,000" },
        { name: "Glenfidich 12yrs", price: "80,000" },
        { name: "Glenfidich 15yrs", price: "140,000" },
        { name: "Glenfidich 18yrs", price: "170,000" },
        { name: "Glenfidich 21yrs", price: "600,000" },
        { name: "William Lawson", price: "30,000" },
        { name: "Jameson Irish", price: "40,000" },
        { name: "Red Label", price: "35,000" },
        { name: "Jameson Black", price: "65,000" },
        { name: "Monkey Shoulder", price: "65,000" },
        { name: "American Honey", price: "55,000" },
        { name: "Meukow VS", price: "72,000" },
        { name: "Meukow VSOP", price: "122,000" },
        { name: "Jack Daniels", price: "60,000" },
      ],
    },
    {
      title: "Tequila and Exit",
      items: [
        { name: "Sierra Tequilla", price: "40,000" },
        { name: "Barcadi", price: "40,000" },
        { name: "Olmeca White", price: "55,000" },
        { name: "Azul", price: "480,000" },
        { name: "Camino", price: "40,000" },
        { name: "Olmeca Chocolate", price: "55,000" },
      ],
    },
    {
      title: "Shakes & Milkshake",
      items: [
        { name: "D Plug Special Milkshake", price: "25,000", recommended: true },
        { name: "Special Milkshake", price: "20,000" },
        { name: "Oreo Choco", price: "10,000" },
        { name: "Bailey Choco", price: "10,000" },
        { name: "Vanilla Caramel", price: "10,000" },
      ],
    },
    {
      title: "Classic Cocktail Drink",
      items: [
        { name: "Strawberry Daiguiri", price: "10,000" },
        { name: "Porn Star Martini", price: "10,000" },
        { name: "Martini", price: "10,000" },
        { name: "Tonic Water", price: "10,000" },
        { name: "Tropical Sunrise", price: "12,000" },
        { name: "African Zombie", price: "10,000" },
        { name: "Strawberry Majito", price: "8,000" },
        { name: "Virgin Majito", price: "10,500" },
        { name: "Long Island Ice Tea", price: "10,000" },
        { name: "Alcoholic Chapman", price: "10,000" },
        { name: "Sex on the Beach", price: "10,000" },
        { name: "Tequila Sunrise", price: "10,000" },
        { name: "D' Plug Elixir", price: "10,000" },
        { name: "Marital", price: "10,000" },
        { name: "White Russia", price: "10,000" },
        { name: "Moscow Mule", price: "10,000" },
        { name: "Margarita", price: "10,000" },
        { name: "Mojito", price: "10,000" },
        { name: "Strawberry Mojito", price: "10,000" },
        { name: "Pink Tan Lady", price: "10,000" },
        { name: "Scream Organs (Dick Glass)", price: "10,000" },
        { name: "Knock Me Out", price: "10,000" },
        { name: "Wet Pussy", price: "10,000" },
        { name: "Sir Efex Special", price: "10,000" },
        { name: "White Lady", price: "12,000" },
        { name: "Days Special", price: "12,000" },
      ],
    },
    {
      title: "Cocktail",
      items: [
        { name: "Blue Hawaii", price: "10,000" },
        { name: "Gin and Tonic", price: "10,000" },
        { name: "Old Fashioned", price: "10,000" },
        { name: "Audios Mothersfucker", price: "10,000" },
      ],
    },
    {
      title: "Mocktail",
      items: [
        { name: "Coco Mellon", price: "8,000" },
        { name: "Frozen Virgin Colada", price: "8,000" },
        { name: "Love in Bahamas", price: "8,000" },
        { name: "Virgin Daiquiri", price: "8,000" },
        { name: "Champ Man", price: "9,000" },
        { name: "Fresh Lime Soda", price: "8,000" },
        { name: "Blue City", price: "8,000" },
        { name: "Virgin Mojito", price: "8,000" },
      ],
    },
    {
      title: "D Plug Signature Cocktail",
      items: [
        { name: "Hemistry", price: "10,000" },
        { name: "Gings & Brooze", price: "10,000" },
        { name: "Carriben Island", price: "10,000" },
        { name: "The Blue Sea", price: "10,000" },
      ],
    },
    {
      title: "Soft Drinks",
      items: [
        { name: "Coke", price: "2,000" },
        { name: "Fanta", price: "2,000" },
        { name: "Blue Bullet", price: "2,500" },
        { name: "Schweppes", price: "2,000" },
        { name: "Power Horse", price: "2,500" },
        { name: "Fayrouz", price: "2,000" },
        { name: "Sprite", price: "2,000" },
        { name: "Chivita", price: "6,000" },
        { name: "Red Bull", price: "2,500" },
        { name: "Water", price: "1,000" },
        { name: "Parfait", price: "6,000" },
      ],
    },
    {
      title: "Dessert",
      items: [
        { name: "Ice Cream Scoop", price: "10,000" },
        { name: "Sierra Tequila Shots", price: "3,000" },
      ],
    },
  ]

  const filteredSections = useMemo(() => {
    let sections =
      activeFilter === "all"
        ? [...foodSections, ...drinkSections]
        : activeFilter === "food"
          ? foodSections
          : drinkSections

    if (searchQuery.trim()) {
      const query = searchQuery.toLowerCase()
      sections = sections
        .map((section) => ({
          ...section,
          items: section.items.filter((item) => item.name.toLowerCase().includes(query)),
        }))
        .filter((section) => section.items.length > 0)
    }

    return sections
  }, [activeFilter, searchQuery])

  const showFoodHeader = activeFilter === "all" || activeFilter === "food"
  const showDrinksHeader = activeFilter === "all" || activeFilter === "drinks"

  return (
    <div className="min-h-screen flex flex-col">
      <MenuHeader />

      <MenuNavigation onSearch={setSearchQuery} onFilterChange={setActiveFilter} activeFilter={activeFilter} />

      <main className="flex-1 container mx-auto px-4 md:px-6 py-12 md:py-16 lg:py-24 max-w-7xl">
        {!searchQuery && activeFilter === "all" && <RecommendedItems items={recommendedItems} />}

        {searchQuery && (
          <div className="mb-8 text-center">
            <p className="text-muted-foreground">
              Found {filteredSections.reduce((acc, section) => acc + section.items.length, 0)} items matching "
              {searchQuery}"
            </p>
          </div>
        )}

        {activeFilter === "all" && !searchQuery ? (
          <>
            <div className="mb-16 md:mb-24">
              <div className="flex items-center justify-center gap-3 md:gap-4 mb-12 md:mb-16">
                <div className="h-px bg-accent/30 flex-1 max-w-[100px] md:max-w-xs" />
                <h2 className="text-3xl sm:text-4xl md:text-5xl lg:text-7xl font-bold text-center text-balance px-2">
                  Food Menu
                </h2>
                <div className="h-px bg-accent/30 flex-1 max-w-[100px] md:max-w-xs" />
              </div>
              <div className="grid md:grid-cols-2 gap-x-8 md:gap-x-12 lg:gap-x-16 gap-y-12 md:gap-y-16 lg:gap-y-20">
                {foodSections.map((section, index) => (
                  <MenuSection key={index} {...section} />
                ))}
              </div>
            </div>

            <div>
              <div className="flex items-center justify-center gap-3 md:gap-4 mb-12 md:mb-16">
                <div className="h-px bg-accent/30 flex-1 max-w-[100px] md:max-w-xs" />
                <h2 className="text-3xl sm:text-4xl md:text-5xl lg:text-7xl font-bold text-center text-balance px-2">
                  Drink Menu
                </h2>
                <div className="h-px bg-accent/30 flex-1 max-w-[100px] md:max-w-xs" />
              </div>
              <div className="grid md:grid-cols-2 gap-x-8 md:gap-x-12 lg:gap-x-16 gap-y-12 md:gap-y-16 lg:gap-y-20">
                {drinkSections.map((section, index) => (
                  <MenuSection key={index} {...section} />
                ))}
              </div>
            </div>
          </>
        ) : (
          <div className="grid md:grid-cols-2 gap-x-8 md:gap-x-12 lg:gap-x-16 gap-y-12 md:gap-y-16 lg:gap-y-20">
            {filteredSections.map((section, index) => (
              <MenuSection key={index} {...section} />
            ))}
          </div>
        )}

        {filteredSections.length === 0 && (
          <div className="text-center py-16">
            <p className="text-xl text-muted-foreground">No items found matching your search.</p>
          </div>
        )}
      </main>

      <BackToTop />

      <MenuFooter />
    </div>
  )
}
