import Image from "next/image"

export function MenuHeader() {
  return (
    <header className="relative bg-primary text-primary-foreground py-12 md:py-16 lg:py-24 overflow-hidden border-b border-accent/20">
      <div className="absolute inset-0 bg-gradient-to-b from-transparent via-transparent to-black/30" />

      <div className="container mx-auto px-4 md:px-6 text-center relative z-10">
        <div className="flex items-center justify-center mb-4 md:mb-6">
          <Image
            src="/dplug-logo.png"
            alt="D'Plug Lounge & Restaurant"
            width={400}
            height={150}
            className="w-auto h-20 sm:h-24 md:h-28 lg:h-32 object-contain"
            priority
            quality={90}
          />
        </div>
        <p className="text-base sm:text-lg md:text-xl text-accent/90 max-w-2xl mx-auto text-pretty leading-relaxed font-light px-4">
          Welcome to D&#39;Plug Lounge. Experience exceptional dining with our curated selections..
        </p>
      </div>
    </header>
  )
}
